% getDxInfo.m
function [DxHdr] = getDxInfo(File)
% ---------------------------------------------------------
% get header info of DX3 file that includes:
%                     nChns: number of channels
%     TotalFieldNamesLength: Length of all fields names
%                   nPoints: number of points per channel
%                      year: DAS file data and time
%                       mon: 
%                       day: 
%                      hour: 
%                       min: 
%                       sec: 
%
% Example:
% [DxHdr] = getDxInfo(File);
% addpath U:\SHARED\gxu\GxMatLabLib 
% Dx3File = 'D:\gps\TEST_1_sync_proc.dx3';
%
% DxHdr = 
% 
%                     nChns: 133
%     TotalFieldNamesLength: 1319
%                nMaxPoints: 14376
%                      year: 2006
%                       mon: 6
%                       day: 13
%                      hour: 11
%                       min: 31
%                       sec: 47
%                  EventPts: 500
%                 ChnPoints: [133x1 int32]
% 
% ---------------------------------------------------------
DxHdr = [];
fid=fopen(File,'r'); % existing ?
if fid == -1
    mstr = ['Loading DX Error: Failed to open file ', File, '!'];
    msgbox( mstr, 'Error','error');
    return;
else
    fclose(fid);
end

% load DLL ---
fl = which('LoadDxChannels'); % find file's path
[pathstr, name, ext, versn] = fileparts(fl);
hd = [pathstr, '\LoadDxOut.h'];

% hd = 'E:\My_Utility\LoadDx\LoadDxOut.h'
% pathstr ='E:\My_Utility\Call'  %fortest ??????????????????

DllLib =[pathstr, '\LoadDx'];

loadlibrary (DllLib, hd);
%loadlibrary (DllLib, @HDproto);

if ~libisloaded('LoadDx')
    mstr = ['Loading DX Error: Failed to load DLL = ', DllLib];
    msgbox( mstr, 'Error','error');
    return;
end
%libfunctions LoadDx -full

%load Dx channel info ---
maxChns = 1000; %number of channels
sm.nChns = 0;
sm.pChnPoints = zeros(maxChns,1);
sc = libpointer('DX_INFO1', sm);
calllib('LoadDx', 'get_dx_info', sc,File ); % ---

DxHdr = get(sc, 'Value');
clear sc
unloadlibrary LoadDx;
DxHdr.ChnPoints = DxHdr.pChnPoints(1:DxHdr.nChns);
DxHdr = rmfield(DxHdr, 'pChnPoints');

