% This routine performs data outlier rejection on a single channel at a time, Outlier_Channel.
% Data outliers that deviate from a running average of the data by more than a specified range,
% Outlier_Band, are eliminated from the data channel, and replaced with the value of the running
% average.  The running average is the average value of a specified number of points, I_Width,
% immediately prior to the point of interest.  This routine does not perform outlier elimination
% for the first I_Width number of points of the data channel.
%
% Data within the outlier range is uneffected by this outlier elimination routine.
% The data channel with the outliers eliminated, Outlier_Filtered_Channel, and
% the number of outliers eliminated, Number_of_Outliers, are returned to the calling routine.
%
% If there is an over range of the ultrasonic date, the Outlier_Band is set to 5, added 6/8/98
%
% Variables from calling routine:
%
%	Outlier_Channel	= Raw data channel containing outliers
%	Outlier_Band	= Specified range (deviation from running average) for outlier elimination 
%	I_Width		= Number of points used in running average
%
% Variables returned to calling routine:
%
%	Outlier_Filtered_Channel = Data channel returned with outliers eliminated
%	Number_of_Outliers	 = Number of outliers eliminated
%

function [Outlier_Filtered_Channel,Number_of_Outliers] = out_filt(Outlier_Channel,Outlier_Band_A,I_Width,Over_Range,Over_Range_Start,Over_Range_End);

Outlier_Filtered_Channel = Outlier_Channel;

Outlier_Band_B=7;
Number_of_Outliers = 0;
Time_to_Stop = 0;
Num_Points = size(Outlier_Channel,1);
Hold_Average_Old = 0;

for i = 1:Num_Points
  Outlier_Band(i)=Outlier_Band_A;
end
if Over_Range > 0
 for i=1:Over_Range 
  for ii=Over_Range_Start(i):Over_Range_End(i)
    Outlier_Band(ii)=Outlier_Band_B;  
  end  
 end
end

for i = 1:Num_Points-I_Width

% Set Outlier_Band basesd on whether or not there is an over range

  

  if i >= I_Width+1

    Hold_Average = 0.0;

%   Compute initial Hold_Average, Hold_Average_Old, for use in first point calculation

    if i == I_Width+1
      for j = 1:I_Width
        Hold_Average_Old = Hold_Average_Old+Outlier_Filtered_Channel(i-j);
      end
      Hold_Average_Old = Hold_Average_Old/I_Width;
    end

%   Include I_Width number of points prior to current point in Hold_Average

    for j = 1:I_Width

      Hold_Average = Hold_Average+Outlier_Filtered_Channel(i-j);

    end

%   Include I_Width number of points after current point, and within Outlier_Band, in Hold_Average

    k = 1;
    ii = i;

    while k <= I_Width

      if abs(Outlier_Channel(ii) - Hold_Average_Old) <= Outlier_Band(ii)

        Hold_Average = Hold_Average+Outlier_Filtered_Channel(ii);
        k = k + 1;

      else

        ii = ii + 1;
        if ii == Num_Points;
	  Time_to_Stop = 1;
	  k = I_Width+1;

        end

      end        

    end

%   Compute Average Value used for Outlier comparison

    if Time_to_Stop == 1;
%     Filter Routine Stopped because End of Good Data at End of File
    else
      Hold_Average = Hold_Average/(2*I_Width);
      Hold_Average_Old = Hold_Average;

        if abs(Outlier_Channel(i) - Hold_Average) >= Outlier_Band(ii)

        Outlier_Filtered_Channel(i) = Hold_Average;
        Number_of_Outliers = Number_of_Outliers + 1;
 
        end
   end 

  end

end
