% read Xls file
% convert num to text
% put all cells of one line into a string delimited with comma
% put the string line into a cell array.
function [LineAry] = readXls2LineAry_1(XlsFile, sheet)
[num, txt, raw] = xlsread(XlsFile, sheet);
clear num txt;
LineAry = [];
nLineAry = 0;
[rows, cols] = size(raw);
for i = 1:rows
    line = [];
    for j = 1:cols
        if iscellstr(raw(i,j))
            str = char(raw(i,j));
        else
            val = cell2mat(raw(i,j));
            if isnan(val)
                str = [];
            else
                str = num2str(val);
            end
        end
        if j == 1
            line = str;
        else
            line = [line,',', str];
        end
    end
    nLineAry = nLineAry +1;
    LineAry{nLineAry} = line;
end











